﻿<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
	<TITLE>Struktura zatrudnienia</TITLE>
	<script runat="server">

    public class PrnParams : ContextBase {
        public PrnParams(Context context) : base(context) {
            Date data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            okres = data.ToYearMonth().ToFromTo();
            podsumowanie = false;
        }

        FromTo okres;
        [Priority(10)]
        [Caption("Raport za okres")]
        public FromTo Okres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool podsumowanie;
        [Priority(20)]
        [Caption("Tylko podsumowanie")]
        public bool Podsumowanie {
            get { return podsumowanie; }
            set {
                podsumowanie = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    PrnParams pars = null;
    [Context(Required = true)]
    public PrnParams Params {
        set { pars = value; }
    }

    class StrukturaZatrudnienia {
        public StrukturaZatrudnienia(string opis) {
            this.opis = opis;
            osPracownicy = 0;
            osChalupnicy = 0;
            osWspolpracujace = 0;
            osUczen1kl = 0;
            osUczen2kl = 0;
            osUczen3kl = 0;
            osPrzyuczany = 0;
            etPracownicy = 0m;
            etChalupnicy = 0m;
            etWspolpracujace = 0m;
            etUczenkl = 0m;
        }

        public void Dodaj(decimal osPracownicy, decimal osChalupnicy, decimal osWspolpracujace,
            decimal osUczen1kl, decimal osUczen2kl, decimal osUczen3kl, decimal osPrzyuczany,
            decimal etPracownicy, decimal etChalupnicy, decimal etWspolpracujace, decimal etUczenkl) {
            this.osPracownicy += osPracownicy;
            this.osChalupnicy += osChalupnicy;
            this.osWspolpracujace += osWspolpracujace;
            this.osUczen1kl += osUczen1kl;
            this.osUczen2kl += osUczen2kl;
            this.osUczen3kl += osUczen3kl;
            this.osPrzyuczany += osPrzyuczany;
            this.etPracownicy += etPracownicy;
            this.etChalupnicy += etChalupnicy;
            this.etWspolpracujace += etWspolpracujace;
            this.etUczenkl += etUczenkl;
        }
                
        public void Dodaj(PracHistoria ph, Date data) {
            decimal wymiar = (decimal)ph.Etat.Wymiar.Value;
            foreach (Pracownik pp in ph.Pracownik.Pracownicy) {
                if (pp.AccessRight == AccessRights.Denied)
                    continue;
                PracHistoria phh = pp[data];
                if (phh.Etat.OkresZatrudnienia.Contains(data))
                    wymiar += (decimal)phh.Etat.Wymiar.Value;
            }

            if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.NieDotyczy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikZaGranicą) {
                osPracownicy++;
                etPracownicy += wymiar;
            }
            else if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Chałupnik) {
                osChalupnicy++;
                etChalupnicy += wymiar;
            }
            else if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.OsobaWspółpracująca) {
                osWspolpracujace++;
                etWspolpracujace += wymiar;
            }
            else if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Uczeń1Klasy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Uczeń2Klasy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Uczeń3Klasy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.MłodocianyPrzyuczany) {
                    if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Uczeń1Klasy)
                        osUczen1kl++;
                    else if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Uczeń2Klasy)
                        osUczen2kl++;
                    else if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Uczeń3Klasy)
                        osUczen3kl++;
                    else if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.MłodocianyPrzyuczany)
                        osPrzyuczany++;
                etUczenkl += wymiar;
            }
        }

        private string Format(decimal value, bool type) {
            string str = string.Empty;
            if (type && opis != "Średnia")
                str = string.Format("{0}", value);
            else
                str = string.Format("{0:n}", value);
            if (opis == "Razem" || opis == "Średnia")
                str = string.Format("<b>{0}</b>", str);
            return str;
        }
                
        private string opis;
        public string Opis {
            get {
                if (opis == "Razem" || opis == "Średnia")
                    return string.Format("<b>{0}</b>", opis);
                else
                    return opis;
            }
        }
                
        private decimal osPracownicy;
        public decimal OsPracownicy {
            get { return osPracownicy; }
        }
        public string StrOsPracownicy {
            get { return Format(osPracownicy, true); }
        }
        
        private decimal osChalupnicy;
        public decimal OsChalupnicy {
            get { return osChalupnicy; }
        }
        public string StrOsChalupnicy {
            get { return Format(osChalupnicy, true); }
        }
        
        private decimal osWspolpracujace;
        public decimal OsWspolpracujace {
            get { return osWspolpracujace; }
        }
        public string StrOsWspolpracujace {
            get { return Format(osWspolpracujace, true); }
        }

        private decimal osUczen1kl;
        public decimal OsUczen1kl {
            get { return osUczen1kl; }
        }
        public string StrOsUczen1kl {
            get { return Format(osUczen1kl, true); }
        }
        
        private decimal osUczen2kl;
        public decimal OsUczen2kl {
            get { return osUczen2kl; }
        }
        public string StrOsUczen2kl {
            get { return Format(osUczen2kl, true); }
        }

        private decimal osUczen3kl;
        public decimal OsUczen3kl {
            get { return osUczen3kl; }
        }
        public string StrOsUczen3kl {
            get { return Format(osUczen3kl, true); }
        }

        private decimal osPrzyuczany;
        public decimal OsPrzyuczany {
            get { return osPrzyuczany; }
        }
        public string StrOsPrzyuczany {
            get { return Format(osPrzyuczany, true); }
        }
        
        private decimal etPracownicy;
        public decimal EtPracownicy {
            get { return etPracownicy; }
        }
        public string StrEtPracownicy {
            get { return Format(etPracownicy, false); }
        }

        private decimal etChalupnicy;
        public decimal EtChalupnicy {
            get { return etChalupnicy; }
        }
        public string StrEtChalupnicy {
            get { return Format(etChalupnicy, false); }
        }

        private decimal etWspolpracujace;
        public decimal EtWspolpracujace {
            get { return etWspolpracujace; }
        }
        public string StrEtWspolpracujace {
            get { return Format(etWspolpracujace, false); }
        }

        private decimal etUczenkl;
        public decimal EtUczenkl {
            get { return etUczenkl; }
        }
        public string StrEtUczenkl {
            get { return Format(etUczenkl, false); }
        }
    }

    List<StrukturaZatrudnienia> list;

    StrukturaZatrudnienia FindStruktura(string opis) {
        foreach (StrukturaZatrudnienia sz in list)
            if (sz.Opis == opis)
                return sz;
        return null;
    }
    
    void dc_ContextLoad(Object sender, EventArgs args) {
        ReportHeader["OKRES"] = pars.Okres.ToString();

        list = new List<StrukturaZatrudnienia>();
        List<Pracownik> pracownicy = new List<Pracownik>();
        SubTable st = KadryModule.GetInstance(dc).Pracownicy.WgNazwiska;
        foreach (Pracownik prac in st) {
            if (prac.AccessRight == AccessRights.Denied)
                continue;
            if (!pracownicy.Contains(prac.EtatGłówny))
                pracownicy.Add(prac.EtatGłówny);
        }
        foreach (Pracownik prac in pracownicy) {
            PracHistoria ph = prac[pars.Okres.From];
            foreach (Date data in pars.Okres) {
                if (!ph.Aktualnosc.Contains(data))
                    ph = prac[data];
                StrukturaZatrudnienia sz = FindStruktura(data.ToString());
                if (sz == null) {
                    sz = new StrukturaZatrudnienia(data.ToString());
                    list.Add(sz);
                }
                if (ph.Etat.OkresZatrudnienia.Contains(data))
                    sz.Dodaj(ph, data);
            }
        }
        DodajRazemSrednia();

        Grid1.DataSource = list;
    }

    void DodajRazemSrednia() {
        StrukturaZatrudnienia razem = new StrukturaZatrudnienia("Razem");
        StrukturaZatrudnienia srednia = new StrukturaZatrudnienia("Średnia");

        int len = list.Count;
        foreach (StrukturaZatrudnienia sz in list)
            razem.Dodaj(sz.OsPracownicy, sz.OsChalupnicy, sz.OsWspolpracujace,
                sz.OsUczen1kl, sz.OsUczen2kl, sz.OsUczen3kl, sz.OsPrzyuczany,
                sz.EtPracownicy, sz.EtChalupnicy, sz.EtWspolpracujace, sz.EtUczenkl);
        srednia.Dodaj(razem.OsPracownicy / len, razem.OsChalupnicy / len, razem.OsWspolpracujace / len,
            razem.OsUczen1kl / len, razem.OsUczen2kl / len, razem.OsUczen3kl / len, razem.OsPrzyuczany / len,
            razem.EtPracownicy / len, razem.EtChalupnicy / len, razem.EtWspolpracujace / len, razem.EtUczenkl / len);

        if (pars.Podsumowanie)
            list.Clear(); 
        list.Add(razem);
        list.Add(srednia);
    }
    
	</script>
	
	<META content="C#" name="CODE_LANGUAGE">
	<META content="JavaScript" name="vs_defaultClientScript">
	<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" oncontextload="dc_ContextLoad" runat="server"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="STRUKTURA ZATRUDNIENIA|ZA OKRES %OKRES%"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server">
				<Columns>
					<ea:GridColumn runat="server" DataMember="Opis" Align="Left" Caption="Data" RightBorder="Double"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsPracownicy" Align="Right" Caption="Osoby~Pracownicy"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsChalupnicy" Align="Right" Caption="Osoby~Chałupnicy"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsWspolpracujace" Align="Right" Caption="Osoby~Os. współp."></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsUczen1kl" Align="Right" Caption="Osoby~Uczeń 1 kl."></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsUczen2kl" Align="Right" Caption="Osoby~Uczeń 2 kl."></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsUczen3kl" Align="Right" Caption="Osoby~Uczeń 3 kl."></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrOsPrzyuczany" Align="Right" Caption="Osoby~Przyuczany" RightBorder="Double"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrEtPracownicy" Align="Right" Caption="Pełne etaty~Pracownicy"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrEtChalupnicy" Align="Right" Caption="Pełne etaty~Chałupnicy"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrEtWspolpracujace" Align="Right" Caption="Pełne etaty~Os. współp."></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="StrEtUczenkl" Align="Right" Caption="Pełne etaty~Uczniowie"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

